#ifndef __ExpStdIncludes__
#define __ExpStdIncludes__

/**
 * @file StdIncludes.h
 * @brief Generic include files
 *
 * Essentially a precompiled header. Provides all the windows and carbon headers required throughout the API.
 *
 * @date 21/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: StdIncludes.h,v 1.4 2007/02/08 21:06:44 paul Exp $
 */

/**
 * @cond
 */
#ifdef WIN32
// Win32

	// Define the windows version
	#define _WIN32_WINNT 0x0501
	#define WINVER 0x0501

	// Now the includes pacakages
	#include <windows.h>
	#include <tchar.h>
	#include <shlobj.h>
	
	// Only included on windows. For some reason GCC 4.0 finds this hard to cope with :|
	#include <iostream>		
#else

	// Need to include carbon..
	#include <Carbon/Carbon.h>
	#include <CoreServices/CoreServices.h>
	#include <mach/mach.h>
	#include <mach/mach_time.h>
	#include <typeinfo>

#endif
/**
 * @endcond
 */


// Standard
#include <cstdio>
#include <cstdlib>
#include <cmath>

#endif	// End of StdIncludes.h